<?php
/*
  This plugin allows detection of robot user agents (for example, site visitors) based
  on a XML database which can be downloaded from http://www.user-agents.org/allagents.xml.
*/

  BIndex::Add('RobotXmlDB', 'file');
  BEvent::HookInstanceOf('RobotxmldbFileIndex', 'IsRobotAgent', 'is robot agent');

/* one-shot */
  $this->name = 'robots xml';
  $this->Caption('XML database of robots\' user agents');
  $this->Caption('XML-база данных роботов', 'ru');
  $this->info['user files'] = array('RobotxmldbFileIndex', 'UserFiles');

/* install RobotxmldbFileIndex */
class RobotxmldbFileIndex extends BaseBoolHashFileIndex {
  static $xmlFile = 'allagents.xml';   // relative to _blog/config/
  // If true will generate index from the XML file and use it for queries onwards
  // instead of loading entire XML on each page request. This makes lookup as fast as
  // 8 times, if you're using some PHP accelerator then it's even higher (up to 10).
  static $cache = true;

  public $indexName = 'robot-xml-db';

  function IsRobotAgent(&$result, $str) {
    if ($this->Select($str)) {
      $result = true;
      return true;
    }
  }

  function Select($str) {
    $robots = &self::Load($this->indexName);

    if (!$robots or !self::$cache) {
      $xml = self::LoadFromXML(self::FileName());
      if (self::$cache) {
        $robots = $this->ToArray($xml);
        $this->Modified();
      } else {
        return self::FindRobotInXML($xml, $str);
      }
    }

    $str = strtr($str, '"', '\'');
    return !empty($robots[$str]);
  }

    static function FileName() { return ToAbsolutePath(self::$xmlFile, BConfig::$paths['config']); }

    static function LoadFromXML($file) {
      $doc = new DOMDocument;
      if (!$doc->load($file, LIBXML_NONET)) {
        throw new BException('Cannot load robots XML database.', 'file: '.$file);
      }

      return $doc;
    }

    static function FindRobotInXML($xml, $str) {
      $xpath = new DOMXPath($xml);
      $match = $xpath->evaluate('/user-agents/user-agent[String = "'.strtr($str, '"', '\'').'"]/Type');

      foreach ($match as $node) {
        $type = strtolower($node->nodeValue);
        if ($type === 'r' or $type === 's') { return true; }
      }
    }

    static function ToArray($xml) {
      static $robotTypes = array('r' => true, 's' => true);
      $result = array();

      foreach ($xml->getElementsByTagName('user-agent') as $node) {
        $agent = $type = null;
        foreach ($node->childNodes as $child) {
          if (strtolower($child->nodeName) === 'string') {
            $agent = $child->nodeValue;
          } elseif (strtolower($child->nodeName) === 'type' and
                    isset($robotTypes[ strtolower($child->nodeValue) ])) {
            $type = true;
          }
        }

        if ($agent and $type) {
          $result[$agent] = $type;
        }
      }

      return $result;
    }

  static function UserFiles() { return self::FileName(); }
}
